//
//  MCDocument.h
//  ISViews
//
//  Created by Michael Clark on Fri Feb 27 2004.
//  Copyright (c) 2004 __MyCompanyName__. All rights reserved.
//

#import <AppKit/AppKit.h>

#import "MCMenuManagerSupportProtocol.h"

@class MCWindowWorkspace,MCSourceListManager;

@interface MCDocument : NSDocument <MCMenuManagerSupport>{
	// An array of MCWindowWorkspace instances
	NSMutableArray *workspaces;

	// The currently selected workspace. Ideally this should never be nil after the document is loaded
	MCWindowWorkspace *currentWorkspace;

	MCSourceListManager*     sourceListManager;

	NSMutableArray *workspacesConfiguration; // this is the top of the tree that contains all the workspaces and their configs

	BOOL usesWorkspaces; // set this to YES in order to activate the workspace features

	// This is a dictionary that gets saved to defaults, it represents the configuration of the last opened window controller
	// it is keyed by window controller classname
	NSMutableDictionary *defaultWindowControllerConfigs;
}

// Overridden by implementing apps, this method should return the classname of the window controller they would like to be loaded
// by default
- (NSString *)mainWindowControllerClassname;

// Overridden by implementing apps, this method calls makeWindowControllerOfClass with the appropriate subclass of 
// MCMainWindowController that is applicable to their app. This is useful if there are no windows and we need to create one
// For the user, or if the user requests a new main window
- (id)createNewMainWindowController;

// Looks through the documents list of window controllers for the first one 
// which is the same as the passed in Class
// Returns nil if none are found
- (id)firstWindowControllerOfClass:(Class)aClass;

// Creates an instances of the passed in Class
// Adds the new instance to the documents list of window controllers and set the document
//  on the controller
// Returns the newly created controller
- (id)makeWindowControllerOfClass:(Class)aClass;

// Same as above only it also adds the window controller to the window controllers of the workspace
- (id)makeWindowControllerForCurrentWorkspaceOfClass:(Class)aClass;

// Finds the first window controller of the past in Class, if none are found it will
// create one if the createIfNotFound flag is YES.
// Also, if passing in YES for showWindow the window will be automatically displayed.
- (id)firstWindowControllerOfClass:(Class)aClass
                  createIfNotFound:(BOOL)flag showWindow:(BOOL)show;
- (id)firstWindowControllerOfClassNamed:(NSString *)classname
					   createIfNotFound:(BOOL)flag showWindow:(BOOL)show;

// Finds the first window controller (in order of when they were last made key)
- (id)firstOrderedWindowControllerOfClass:(Class)aClass;

// Attempts to find an open editor for the passed in object by calling editorForObject:
// If one is found then this method interacts with the window controllers TVC to add the obj if needed
// and select the object
//- (void)focusOnObject: (id)obj;

// Looks in our window controllers and tries to find an editor already open for the specified
// object.  If it cannot find one, then it will return nil
//- (id)editorForObject:(id)anObject;

// First tries to find an existing open editor for object
// If none are found then a new one is created and displayed
//- (void)openEditorForObject:(id)anObject;

// Will run the sheet window as a sheet on the host window
// The modal delegate for the sheet will be the document, and the document will clean up the window
// and its associated controller.  The sheet implementation must call the NSApp endSheet method to end
// the modal session.
- (void)runSheetWindow: (NSWindow *)sheet forHostWindow: (NSWindow *)hostWindow;

// Returns whether the object is writable, returns YES by default
- (BOOL)currentUserHasWritePermissionForObject:(id)anObj;

// Saves the document and logs out(saves workspaces too if applicable)
- (IBAction)logout:(id)sender;

- (IBAction)refresh:(id)sender;

// Puts up an alert if there are any editing window controllers
- (BOOL)closeAllEditingWindowControllers;

- (void)runFScriptAtPath:(NSString *)aPath withArguments:(NSDictionary *)args showAlerts:(BOOL)showAlerts;
- (void)runFScriptAtPath:(NSString *)aPath withArguments:(NSDictionary *)args;
- (void)runFScriptAtPath:(NSString *)aPath; // wraps the above method with nil for args

#pragma mark WorkspaceMethods
// This method will ask for the configurations, create MCWindowWorkspace instances from them, and load the last workspace
- (void)loadWorkspaces;
// this method should go to wherever workspace configurations are found and load them up, with mutable leaves and containers
- (NSMutableArray *)workspaceConfigurations;
// This method should go to wherever the last workspace name was stored and return it
- (NSString *)lastWorkspaceName;
// This method will the workspace configurations
- (void)saveWorkspaces;

#pragma mark Accessors
- (NSMutableArray *)workspacesConfiguration;
- (void)setWorkspacesConfiguration:(NSMutableArray *)aWorkspacesConfiguration;

- (MCSourceListManager *)sourceListManager;
- (void)setSourceListManager:(MCSourceListManager *)aSourceListManager;

- (NSMutableArray *)workspaces;
- (void)setWorkspaces:(NSMutableArray *)aWorkspaces;
- (MCWindowWorkspace *)currentWorkspace;
- (void)setCurrentWorkspace:(MCWindowWorkspace *)aCurrentWorkspace;

- (BOOL)usesWorkspaces;
- (void)setUsesWorkspaces:(BOOL)flag;

- (NSMutableDictionary *)defaultWindowControllerConfigs;
- (void)setDefaultWindowControllerConfigs:(NSMutableDictionary *)aDefaultWindowControllerConfigs;
@end
